import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.salesRegionId) {
    newObjValue = {...newObjValue, 
      C_SalesRegion_ID: {
        id: body.salesRegionId,
        tableName: 'C_SalesRegion'
      }
    }
  }
  if(body.locationId) {
    newObjValue = {...newObjValue, 
      C_Location_ID: {
        id: body.locationId,
        tableName: 'C_Location'
      }
    }
  }
  if(body.organizationId) {
    newObjValue = {...newObjValue, 
      AD_Org_ID: {
        id: body.organizationId,
        tableName: 'AD_Org'
      }
    }
  }

  if(body.id) {
    const res: any = await fetchHelper(event, 'models/c_bpartner_location/'+body.id, 'PUT', token, {
      isActive: body.isActive,
      name: body.name,
      phone: body.phone,
      phone2: body.phone2,
      fax: body.fax,
      ISDN: body.ISDN,
      isBillTo: body.isBillTo,
      isShipTo: body.isShipTo,
      isPayFrom: body.isPayFrom,
      isRemitTo: body.isRemitTo,
      isPreserveCustomName: body.isPreserveCustomName,
      ...newObjValue,
      tableName: 'C_BPartner_Location'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      //forceLogoutHelper(event, data)
    }
  }

  return data
})